﻿/***************************************************************************/
/**                                                                       **/
/**                               MAGICARD                                **/
/**                                                                       **/
/***************************************************************************/
/**                                                                       **/
/**  PROJECT      : SDK C# Demo - Ultima Printers                         **/
/**                                                                       **/
/**  MODULE NAME  : Main.cs                                               **/
/**                                                                       **/
/**  COPYRIGHT    : Magicard                                              **/
/**                                                                       **/
/***************************************************************************/
using System;
using System.Windows.Forms;
using System.Drawing.Printing;
using System.Runtime.InteropServices;
using SDKShim;

namespace CSharpDemo
{
    [System.Runtime.InteropServices.GuidAttribute("C60551F2-7329-4249-866F-3D0DBA37CD61")]
    public partial class SDK_CSDemo : Form
    {
        #region === Initialisation ===

        private bool EncodingTabInit  = false;
        private bool Driver1TabInit   = false;
        private bool Driver2TabInit   = false;
        private bool PrintDemoTabInit = false;

        public SDK_CSDemo()
        {
            InitializeComponent();

#if (x86)
            this.Text = "Ultima SDK C# Demo (32 bit)";
#else
            this.Text = "Ultima SDK C# Demo (64 bit)";
#endif
            //Hide tabs other than Printer Settings
            TabControl.Controls.Remove(Information);
            TabControl.Controls.Remove(MagEncoding);
            TabControl.Controls.Remove(DriverSettings1);
            TabControl.Controls.Remove(DriverSettings2);
            TabControl.Controls.Remove(PrintDemo);

            //Initialise the individual tabs
            InitPrinterTab();
            InitInfoTab();
            InitEncodingTab();
            InitDriver1Tab();
            InitDriver2Tab();
            InitPrintDemoTab();
        }

        #endregion === Initialisation ===

        //----------------------------------------------------------------------

        #region === Local Methods ===

        //private bool PrinterIsReady()
        //{
        //    return (SDK.ID_PrinterStatus(hSession) == SDK.PrinterStatus.Ready);
        //}

        private void TabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            switch (TabControl.SelectedIndex)
            {
			case 0:
                // Printer tab does not require initialisation
				break;
				
            case 1:
                // Info tab does not require initialisation
            	break;

            case 2:
                if (!EncodingTabInit)
                {
                    EncodingTabInit = true;

                    //...Magnetic Encoding Start Position
                    int MagStart = 0;
                    GetMagStart(ref MagStart);
                }
                break;

            case 3:
                if (!Driver1TabInit)
                {
                    Driver1TabInit = true;
                    SDK.Area Area = new SDK.Area();
                    //Initialise the Controls on the Driver 1 Page...
                    //...GUIControl
                    SDK.GUIControl control = new SDK.GUIControl();
                    GetGUIControl(ref control);

                    //...Sharpness
                    sbyte temp = 0;
                    GetSharpness(ref temp);

                    //...Colour Correction
                    SDK.Correction ColCorrect = new SDK.Correction();
                    GetColourCorrection(ref ColCorrect);

                    //...Power Level
                    SDK.PowerLevel PowerLevel = new SDK.PowerLevel();
                    GetPowerLevels(ref PowerLevel);

                    //...Resin Area
                    GetResinArea(SDK.Side.Front, 1, ref Area);

                    //...ColourArea
                    ColourAreaLeftUpDown.Maximum  = SDK.ID_CardWidth(hSession) - 1;
                    ColourAreaWidthUpDown.Maximum = SDK.ID_CardWidth(hSession);
                    SDK.Correction Correction = new SDK.Correction();
                    GetColourArea(SDK.Side.Front, 1, ref Area, ref Correction);
                }
                break;

            case 4:
                if (!Driver2TabInit)
                {
                    Driver2TabInit = true;

                    foreach (PaperSize p in pd.PrinterSettings.PaperSizes)
                    {
                        cardsizekp.Add(p.RawKind, p.PaperName);
                    }
                    CardSizeCombo.DataSource = new BindingSource(cardsizekp, null);
                    CardSizeCombo.DisplayMember = "Value";
                    CardSizeCombo.ValueMember = "Key";

                    //Initialise the Controls on the Driver 2 Page...
                    //...Print Settings
                    SDK.PrintSetting PrintSettings = new SDK.PrintSetting();
                    GetPrintSettings(ref PrintSettings);

                    //...Card Settings
                    SDK.CardSetting CardSettings = new SDK.CardSetting();
                    GetCardSettings(SDK.Side.Front, ref CardSettings);

                    //...HoloKote
                    SDK.HoloKote HoloKote = new SDK.HoloKote();
                    GetHoloKote(SDK.Side.Front, ref HoloKote);


                    //...ColourAdjust
                    SDK.ColorAdjustment ColourAdj = new SDK.ColorAdjustment();
                    GetColourAdjust(ref ColourAdj);
                }
                break;

            case 5:
                if (!PrintDemoTabInit)
                {
                    PrintDemoTabInit = true;

                    ShapeFrontFillCombo.Text   = "Transparent";
                    TextBackColourCombo.Text   = "Black";
                    ShapeBackOutlineCombo.Text = "Black";
                    ShapeBackFillCombo.Text    = "Transparent";
                    LineBackColourCombo.Text   = "Black";
                }
                break;
            }
        }

        #endregion === Local Methods ===

        //----------------------------------------------------------------------

        #region === Child Methods ===

        private void HandleError(string action, SDK.Return result)
        {
            string error;

            switch (result)
            {
            case SDK.Return.Timeout:            error = "ID_TIMEOUT";             break;
            case SDK.Return.Error:              error = "ID_ERROR";               break;
            case SDK.Return.PrinterError:       error = "ID_PRINTER_ERROR";       break;
            case SDK.Return.DriverNotCompliant: error = "ID_DRIVER_NOTCOMPLIANT"; break;
            case SDK.Return.OpenPrinterError:   error = "ID_OPENPRINTER_ERROR";   break;
            case SDK.Return.RemoteCommError:    error = "ID_REMOTECOMM_ERROR";    break;
            case SDK.Return.LocalCommError:     error = "ID_LOCALCOMM_ERROR";     break;
            case SDK.Return.SpoolerNotEmpty:    error = "ID_SPOOLER_NOT_EMPTY";   break;
            case SDK.Return.RemoteCommInUse:    error = "ID_REMOTECOMM_IN_USE";   break;
            case SDK.Return.LocalCommInUse:     error = "ID_LOCALCOMM_IN_USE";    break;
            case SDK.Return.ParamError:         error = "ID_PARAM_ERROR";         break;
            case SDK.Return.InvalidSession:     error = "ID_INVALID_SESSION";     break;
            case SDK.Return.MoreData:           error = "ID_MORE_DATA";           break;
            case SDK.Return.InvalidPrinter:     error = "ID_INVALID_PRINTER";     break;
            case SDK.Return.InvalidAction:      error = "ID_INVALID_ACTION";      break;
            case SDK.Return.ReadError:          error = "ID_READ_ERROR";          break;
            case SDK.Return.WriteError:         error = "ID_WRITE_ERROR";         break;
            default: error = "Unknown API Error - " + result; break;
            }
            MessageBox.Show(action + ": " + error);
        }

        //----------------------------------------------------------------------

        private void WaitForPrinterToFinish()
        {
            if (pd.PrintToFile)
                return;

            Cursor.Current = Cursors.WaitCursor;

            do
            {
                //Repeat the wait until response is not timeout
            } while (SDK.ID_WaitForPrinter(hSession) == SDK.Return.Timeout);

            Cursor.Current = Cursors.Default;
        }

        //----------------------------------------------------------------------

        private string Separator(SDK.Action action)
        {
            return (action == SDK.Action.Read) ? ": " : " -> ";
        }

        //----------------------------------------------------------------------

        private void ExitButton_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        #endregion === Child Methods ===

    }
}